/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.event.listeners.abilities;

import com.aetherteam.aether.event.hooks.AbilityHooks;
import com.aetherteam.aether.item.accessories.abilities.ShieldOfRepulsionAccessory;
import io.github.fabricators_of_create.porting_lib.entity.events.LivingAttackEvent;
import io.github.fabricators_of_create.porting_lib.entity.events.LivingEntityEvents;
import io.github.fabricators_of_create.porting_lib.entity.events.PlayerEvents;
import io.github.fabricators_of_create.porting_lib.entity.events.ProjectileImpactEvent;
import io.github.fabricators_of_create.porting_lib.event.common.BlockEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2680;

public class AccessoryAbilityListener {
    public static void onBlockBreak(BlockEvents.BreakEvent event) {
        class_1657 player = event.getPlayer();
        class_1936 level = event.getLevel();
        class_2680 state = event.getState();
        class_2338 pos = event.getPos();
        if (!event.isCanceled()) {
            AbilityHooks.AccessoryHooks.damageZaniteRing((class_1309)player, level, state, pos);
            AbilityHooks.AccessoryHooks.damageZanitePendant((class_1309)player, level, state, pos);
        }
    }

    public static void onMiningSpeed(PlayerEvents.BreakSpeed event) {
        class_1657 player = event.getEntity();
        if (!event.isCanceled()) {
            event.setNewSpeed(AbilityHooks.AccessoryHooks.handleZaniteRingAbility((class_1309)player, event.getNewSpeed()));
            event.setNewSpeed(AbilityHooks.AccessoryHooks.handleZanitePendantAbility((class_1309)player, event.getNewSpeed()));
        }
    }

    public static void onTargetSet(LivingEntityEvents.LivingVisibilityEvent event) {
        class_1297 lookingEntity;
        class_1309 livingEntity = event.getEntity();
        if (AbilityHooks.AccessoryHooks.preventTargeting(livingEntity, lookingEntity = event.getLookingEntity()) && !AbilityHooks.AccessoryHooks.recentlyAttackedWithInvisibility(livingEntity, lookingEntity)) {
            event.modifyVisibility(0.0);
        }
        if (AbilityHooks.AccessoryHooks.recentlyAttackedWithInvisibility(livingEntity, lookingEntity)) {
            event.modifyVisibility(1.0);
        }
    }

    public static void onProjectileImpact(ProjectileImpactEvent event) {
        class_239 hitResult = event.getRayTraceResult();
        class_1676 projectile = event.getProjectile();
        ShieldOfRepulsionAccessory.deflectProjectile(event, hitResult, projectile);
    }

    public static void onEntityHurt(LivingAttackEvent event) {
        class_1309 livingEntity = event.getEntity();
        class_1282 damageSource = event.getSource();
        AbilityHooks.AccessoryHooks.setAttack(event.getSource());
        if (AbilityHooks.AccessoryHooks.preventMagmaDamage(livingEntity, damageSource)) {
            event.setCanceled(true);
        }
    }

    public static void init() {
        BlockEvents.BLOCK_BREAK.register(AccessoryAbilityListener::onBlockBreak);
        PlayerEvents.BREAK_SPEED.register(AccessoryAbilityListener::onMiningSpeed);
        LivingEntityEvents.LivingVisibilityEvent.VISIBILITY.register(AccessoryAbilityListener::onTargetSet);
        ProjectileImpactEvent.PROJECTILE_IMPACT.register(AccessoryAbilityListener::onProjectileImpact);
        LivingAttackEvent.ATTACK.register(AccessoryAbilityListener::onEntityHurt);
    }
}

